/*******************************************************************
*
*  DESCRIPTION: Atomic Model movementController
*
*  AUTHOR: Dieynaba Alpha Tall
*
*  EMAIL: alphadieynaba@yahoo.fr
*
*
*  DATE: 07/08/2009
*******************************************************************/

#ifndef __MOVEMENTCONTROLLER_H
#define __MOVEMENTCONTROLLER_H

/** include files **/
#include "atomic.h"     // class Atomic

/** declarations **/
class MovementController : public Atomic
{
public:
	MovementController( const std::string &name = "MovementController" ); //Default constructor
	virtual std::string className() const {  return "MovementController" ;}
	~MovementController();

protected:

	Model &initFunction();
	Model &externalFunction( const ExternalMessage & );
	Model &internalFunction( const InternalMessage & );
	Model &outputFunction( const InternalMessage & );

private:
	const Port &mctrl_sctrl_in;
	Port &mctrl_sctrl_out, &mctrl_moveR_out, &mctrl_moveL_out;
	
	Time movePrepTime, turnTime;
	
	int sctrl_input;
	
	enum State{
		IDLE,	//initial state :stop
		PREP_MOVE_FWD,		//movement controller is on: state= prepare to move forward
		MOVE_FWD,  // vehicle move forward
		MX_STOP,    // motors stop 10s
		WAIT_DATA,    // waiting radar signal
		PREP_TURN,			//ask motors to turn
		TURN_ALPHA,          // turning, 10s
		PREP_STOP
	} state;
};	// class MovementController

#endif   //__MOVEMENTCONTROLLER_H
